/******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                Copyright by                                *
 *                                                                            *
 *                              Azoteq (Pty) Ltd                              *
 *                          Republic of South Africa                          *
 *                                                                            *
 *                           Tel: +27(0)21 863 0033                           *
 *                           E-mail: info@azoteq.com                          *
 *                                                                            *
 * ========================================================================== *
 * @file        iqs397_addresses.h                                          *
 * @brief       IQS397 - Registers & Memory Map                             *
 * @author      Azoteq PTY Ltd                                                *
 * @version     v1.0                                                          *
 * @date        2025                                                          *
 * @see         Refer to IQS397 datasheet for more information,             *
 *              available here: https://www.azoteq.com/design/datasheets/     *
 ******************************************************************************/

#ifndef IQS397_ADDRESSES_H
#define IQS397_ADDRESSES_H

/* Device Information - Read Only */

#define IQS397_MM_PROD_NUM 0x0000
#define IQS397_MM_MAJOR_VERSION_NUM 0x0002
#define IQS397_MM_MINOR_VERSION_NUM 0x0004

#define IQS397_MM_SYSTEM_FLAGS 0x2000

/* Device Information - Read-Wriet */

#define IQS397_MM_SYSTEM_COMMANDS 0x1000
#define IQS397_MM_SYSTEM_SETTINGS 0x1001
#define IQS397_MM_I2C_SETTINGS 0x1002

#define IQS397_MM_PF_SETTINGS_0 0x1012
#define IQS397_MM_PF_SETTINGS_1 0x102A

#define IQS397_MM_PF_ATI_SETTINGS 0x1032

#define IQS397_MM_HAPTIC_CONFIG_SETTINGS_0 0x103E
#define IQS397_MM_HAPTIC_CONFIG_SETTINGS_1 0x1044

#define IQS397_MM_DRIVE_SETTINGS 0x1049

#endif /* IQS397_ADDRESSES_H */
