/*
* This file contains all the necessary settings for the IQS397.
* It can be changed from the GUI or edited here.
* File:   IQS397_init.h
* Author: Azoteq
*/

#ifndef IQS397_INIT_H
#define IQS397_INIT_H

/* System Control Settings */
/* Memory Map Position 0x1000 - 0x1011 */
#define AUTO_CLEAR_SETTINGS                      0x00
#define SYSTEM_SETTINGS                          0x82
#define EVENTMASK                                0x1F
#define ULP_SETTINGS                             0x3F
#define AUTO_ULP_THRESHOLD_0                     0xC8
#define AUTO_ULP_THRESHOLD_1                     0x00
#define NP_REPORT_0                              0x2B
#define NP_REPORT_1                              0x00
#define ULP_REPORT_0                             0x2B
#define ULP_REPORT_1                             0x00
#define EMPTY_0                                  0x2B
#define EMPTY_1                                  0x00
#define EMPTY_2                                  0x2B
#define EMPTY_3                                  0x00
#define ULP_TIMEOUT_0                            0x88
#define ULP_TIMEOUT_1                            0x13
#define I2C_TIMEOUT_0                            0xFA
#define I2C_TIMEOUT_1                            0x00

/* Channel 0 Settings 0 */
/* Memory Map Position 0x1012 - 0x1029 */
#define CONVERSION_SETUP                         0xDB
#define CONVERSION_SETTINGS                      0xE3
#define BUTTON_PROX_TIMEOUT_0                    0x20
#define BUTTON_PROX_TIMEOUT_1                    0x4E
#define BUTTON_TOUCH_TIMEOUT_0                   0x20
#define BUTTON_TOUCH_TIMEOUT_1                   0x4E
#define BUTTON_ATI_TIMEOUT_0                     0xD0
#define BUTTON_ATI_TIMEOUT_1                     0x07
#define BUTTON_FILTER_COUNT_BETA                 0x01
#define BUTTON_FILTER_LTA_BETA                   0x08
#define BUTTON_FILTER_LTA_BETA_FAST              0x01
#define BUTTON_FILTER_LTA_ULP_BETA               0x05
#define BUTTON_FILTER_LTA_BETA_FAST_BAND_0       0x05
#define BUTTON_FILTER_LTA_BETA_FAST_BAND_1       0x00
#define EMPTY_4                                  0x01
#define EMPTY_5                                  0x08
#define EMPTY_6                                  0x01
#define EMPTY_7                                  0x05
#define EMPTY_8                                  0x05
#define EMPTY_9                                  0x00
#define BUTTON_PROX_THRESHOLD_0                  0xF4
#define BUTTON_PROX_THRESHOLD_0                  0x01
#define BUTTON_PROX_DEBOUNCE                     0x22
#define EMPTY_10                                 0x00

/* Channel 0 Settings 1 */
/* Memory Map Position 0x102a - 0x1031 */
#define BUTTON_TOUCH_THRESHOLD_0                 0xB0
#define BUTTON_TOUCH_THRESHOLD_1                 0x04
#define BUTTON_TOUCH_DEBOUNCE                    0x11
#define BUTTON_TOUCH_HYST                        0x32
#define BUTTON_ATI_BAND_0                        0x0F
#define BUTTON_ATI_BAND_1                        0x00
#define BUTTON_LTA_HALT_THRESHOLD_0              0xF4
#define BUTTON_LTA_HALT_THRESHOLD_1              0x01

/* Channel 0 ATI Settings */
/* Memory Map Position 0x1032 - 0x103D */
#define SENSOR0_ATI_BASE_0                       0xA0
#define SENSOR0_ATI_BASE_1                       0x0F
#define SENSOR0_ATI_TARGET_0                     0xA0
#define SENSOR0_ATI_TARGET_1                     0x0F
#define EMPTY_11                                 0x88
#define EMPTY_12                                 0x13
#define EMPTY_13                                 0x88
#define EMPTY_14                                 0x13
#define SENSOR0_COARSE                           0xCE
#define SENSOR0_FINE                             0x46
#define SENSOR0_COMPENSATION_0                   0x4C
#define SENSOR0_COMPENSATION_1                   0x02

/* Haptic & H-bridge Configuration */
/* Memory Map Position 0x103E - 0x1043 */
#define HAPTIC_CONTROL_0                         0x01
#define HAPTIC_CONTROL_1                         0x00
#define OVER_TEMPERATURE_SETTINGS_0              0x1C
#define OVER_TEMPERATURE_SETTINGS_1              0x00
#define H_BRIDGE_SETUP_0                         0x3E
#define H_BRIDGE_SETUP_1                         0x15

/* LRA Drive Settings */
/* Memory Map Position 0x1044 - 0x1049 */
#define PWM_FREQUENCY_0                          0x20
#define PWM_FREQUENCY_1                          0x4E
#define LRA_FREQUENCY_0                          0xC8
#define LRA_FREQUENCY_1                          0x00
#define AUTORESONANCE_BACKOFF                    0x50
#define DRIVE_SETTINGS                           0xE0

#endif	/* IQS397_INIT_H */
